

********************************************************************************************************************************************************************
********************************************************************************************************************************************************************
*** Replication do-file for "The Power of Religion"
*** by Jeanet Sinding Bentzen and Gunes Gokmen
*** June, 2022
********************************************************************************************************************************************************************
********************************************************************************************************************************************************************


**********************************************************************************
**********************************************************************************
*** Table A.6: Religious laws and pre-historic belief in high gods across countries, robustness to other aggregation methods
**********************************************************************************
use country_final, clear

* Column 1
reghdfe rslegis god, a(continent) vce(r)
* Column 2
reghdfe rslegis god muslimdum, a(continent) vce(r)


*** 
* Size weighted averages
use ethno_final, clear

local var2 size

keep if `var2'!=.

sum `var2'
gen `var2'w2=`var2'/r(max)

collapse god (first) country [pw=`var2'w2], by(iso3)

rename god god_2

merge 1:1 iso3 using country_final

drop _merge

*egen cont=group(continent)

drop god 
rename god_2 god

* Column 3
reghdfe rslegis god , a(cont) vce(r)
* Column 4
reghdfe rslegis god muslimdum, a(cont) vce(r)


*** Complexity weighted averages
use ethno_final, clear

local var2 complex

keep if `var2'!=.

sum `var2'
gen `var2'w2=`var2'/r(max)

collapse god (first) country [pw=`var2'w2], by(iso3)

rename god god_2

merge 1:1 iso3 using country_final

drop _merge

drop god
rename god_2 god

* Column 5
reghdfe rslegis god, a(cont) vce(r)
* Column 6
reghdfe rslegis god muslimdum, a(cont) vce(r)


***
* Distance to capital weighted averages
use ethno_final, clear

local var2 dist_cap

keep if `var2'!=.

sum `var2'
gen `var2'w2=1/`var2'

collapse god (first) country [pw=`var2'w2], by(iso3)
rename god god_2

merge 1:1 iso3 using country_final

drop _merge

drop god
rename god_2 god

* Column 7
reghdfe rslegis god, a(cont) vce(r)
* Column 8
reghdfe rslegis god muslimdum, a(cont) vce(r)


********************************************************************************************************************************************************************